/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.glassfish.bootstrap;

import com.sun.enterprise.glassfish.bootstrap.MainHelper;
import com.sun.enterprise.glassfish.bootstrap.Util;
import com.sun.enterprise.module.bootstrap.ArgumentManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Arrays;
import java.util.Properties;
import org.glassfish.embeddable.BootstrapProperties;
import org.glassfish.embeddable.CommandResult;
import org.glassfish.embeddable.CommandRunner;
import org.glassfish.embeddable.Deployer;
import org.glassfish.embeddable.GlassFish;
import org.glassfish.embeddable.GlassFishProperties;
import org.glassfish.embeddable.GlassFishRuntime;

public class GlassFishMain {
    public static void main(String[] args) throws Exception {
        MainHelper.checkJdkVersion();
        Properties argsAsProps = ArgumentManager.argsToMap(args);
        String platform = MainHelper.whichPlatform();
        System.out.println("Launching GlassFish on " + platform + " platform");
        System.setProperty("GlassFish_Platform", platform);
        File installRoot = MainHelper.findInstallRoot();
        File instanceRoot = MainHelper.findInstanceRoot(installRoot, argsAsProps);
        Properties ctx = MainHelper.buildStartupContext(platform, installRoot, instanceRoot, args);
        ClassLoader launcherCL = MainHelper.createLauncherCL(ctx, ClassLoader.getSystemClassLoader().getParent());
        Class<?> launcherClass = launcherCL.loadClass(Launcher.class.getName());
        Object launcher = launcherClass.newInstance();
        Method method = launcherClass.getMethod("launch", Properties.class);
        method.invoke(launcher, ctx);
    }

    public static class Launcher {
        private volatile GlassFish gf;
        private volatile GlassFishRuntime gfr;

        public void launch(Properties ctx) throws Exception {
            this.addShutdownHook();
            this.gfr = GlassFishRuntime.bootstrap(new BootstrapProperties(ctx), this.getClass().getClassLoader());
            this.gf = this.gfr.newGlassFish(new GlassFishProperties(ctx));
            if (Boolean.valueOf(Util.getPropertyOrSystemProperty(ctx, "GlassFish_Interactive", "false")).booleanValue()) {
                this.startConsole();
            } else {
                this.gf.start();
            }
        }

        private void startConsole() throws IOException {
            String command;
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            while ((command = this.readCommand(reader)) != null) {
                try {
                    String[] tokens;
                    Deployer deployer;
                    System.out.println("command = " + command);
                    if ("start".equalsIgnoreCase(command)) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED || this.gf.getStatus() == GlassFish.Status.STOPPING || this.gf.getStatus() == GlassFish.Status.STARTING) {
                            this.gf.start();
                            continue;
                        }
                        System.out.println("Already started or stopping or starting");
                        continue;
                    }
                    if ("stop".equalsIgnoreCase(command)) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                            System.out.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        this.gf.stop();
                        continue;
                    }
                    if (command.startsWith("deploy")) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                            System.out.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        deployer = this.gf.getService(Deployer.class, null);
                        tokens = command.split("\\s");
                        if (tokens.length < 2) {
                            System.out.println("Syntax: deploy <options> file");
                            continue;
                        }
                        URI uri = URI.create(tokens[tokens.length - 1]);
                        String[] params = Arrays.copyOfRange(tokens, 1, tokens.length - 1);
                        String name = deployer.deploy(uri, params);
                        System.out.println("Deployed = " + name);
                        continue;
                    }
                    if (command.startsWith("undeploy")) {
                        if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                            System.out.println("GlassFish is not started yet. Please execute start first.");
                            continue;
                        }
                        deployer = this.gf.getService(Deployer.class, null);
                        String name = command.substring(command.indexOf(" ")).trim();
                        deployer.undeploy(name, new String[0]);
                        System.out.println("Undeployed = " + name);
                        continue;
                    }
                    if ("quit".equalsIgnoreCase(command)) {
                        System.exit(0);
                        continue;
                    }
                    if (this.gf.getStatus() != GlassFish.Status.STARTED) {
                        System.out.println("GlassFish is not started yet. Please execute start first.");
                        continue;
                    }
                    CommandRunner cmdRunner = this.gf.getCommandRunner();
                    tokens = command.split("\\s");
                    CommandResult result = cmdRunner.run(tokens[0], Arrays.copyOfRange(tokens, 1, tokens.length));
                    System.out.println((Object)result.getExitStatus());
                    System.out.println(result.getOutput());
                    if (result.getFailureCause() == null) continue;
                    result.getFailureCause().printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }

        private String readCommand(BufferedReader reader) throws IOException {
            this.prompt();
            String command = null;
            while ((command = reader.readLine()) != null && command.isEmpty()) {
            }
            return command;
        }

        private void prompt() {
            System.out.print("Enter any of the following commands: start, stop, quit, deploy <path to file>, undeploy <name of app>\nglassfish$ ");
            System.out.flush();
        }

        private void addShutdownHook() {
            Runtime.getRuntime().addShutdownHook(new Thread("GlassFish Shutdown Hook"){

                @Override
                public void run() {
                    try {
                        gfr.shutdown();
                    }
                    catch (Exception ex) {
                        System.err.println("Error stopping framework: " + ex);
                        ex.printStackTrace();
                    }
                }
            });
        }
    }
}

