/*
 * Decompiled with CFR 0.152.
 */
package com.sun.gjc.util;

import com.sun.enterprise.util.i18n.StringManager;
import com.sun.gjc.common.DataSourceObjectBuilder;
import com.sun.logging.LogDomains;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringBufferInputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.ResourceException;

public class MethodExecutor
implements Serializable {
    private static Logger _logger = LogDomains.getLogger(MethodExecutor.class, (String)"javax.enterprise.resource.resourceadapter");
    private boolean debug = false;
    private static final String newline = System.getProperty("line.separator");
    private static StringManager sm = StringManager.getManager(DataSourceObjectBuilder.class);

    public void runJavaBeanMethod(final String value, final Method method, final Object obj) throws ResourceException {
        if (value == null || value.trim().equals("")) {
            return;
        }
        Class<?>[] parameters = method.getParameterTypes();
        if (parameters.length == 1) {
            final Object[] values = new Object[]{this.convertType(parameters[0], value)};
            final ResourceException[] exception = new ResourceException[1];
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        method.setAccessible(true);
                        method.invoke(obj, values);
                    }
                    catch (IllegalAccessException | SecurityException | InvocationTargetException iae) {
                        _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
                        _logger.log(Level.SEVERE, "", iae);
                        String msg = sm.getString("me.access_denied", (Object)method.getName());
                        exception[0] = new ResourceException(msg);
                    }
                    catch (IllegalArgumentException ie) {
                        _logger.log(Level.SEVERE, "jdbc.exc_jb_val", value);
                        _logger.log(Level.SEVERE, "", ie);
                        String msg = sm.getString("me.illegal_args", (Object)method.getName());
                        exception[0] = new ResourceException(msg);
                    }
                    return null;
                }
            });
            if (exception[0] != null) {
                throw exception[0];
            }
        }
    }

    public void runMethod(final Method method, final Object obj, final Vector values) throws ResourceException {
        Class<?>[] parameters = method.getParameterTypes();
        if (values.size() != parameters.length) {
            return;
        }
        final Object[] actualValues = new Object[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String val = (String)values.get(i);
            actualValues[i] = val.trim().equals("NULL") ? null : this.convertType(parameters[i], val);
        }
        final ResourceException[] exception = new ResourceException[1];
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    method.setAccessible(true);
                    method.invoke(obj, actualValues);
                }
                catch (IllegalAccessException | SecurityException | InvocationTargetException iae) {
                    _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
                    _logger.log(Level.SEVERE, "", iae);
                    String msg = sm.getString("me.access_denied", (Object)method.getName());
                    exception[0] = new ResourceException(msg);
                }
                catch (IllegalArgumentException ie) {
                    _logger.log(Level.SEVERE, "jdbc.exc_jb_val", values);
                    _logger.log(Level.SEVERE, "", ie);
                    String msg = sm.getString("me.illegal_args", (Object)method.getName());
                    exception[0] = new ResourceException(msg);
                }
                return null;
            }
        });
        if (exception[0] != null) {
            throw exception[0];
        }
    }

    private Object convertType(Class type, String parameter) throws ResourceException {
        try {
            Properties p;
            String typeName = type.getName();
            if (typeName.equals("java.lang.String") || typeName.equals("java.lang.Object")) {
                return parameter;
            }
            if (typeName.equals("int") || typeName.equals("java.lang.Integer")) {
                return Integer.valueOf(parameter);
            }
            if (typeName.equals("short") || typeName.equals("java.lang.Short")) {
                return Short.valueOf(parameter);
            }
            if (typeName.equals("byte") || typeName.equals("java.lang.Byte")) {
                return Byte.valueOf(parameter);
            }
            if (typeName.equals("long") || typeName.equals("java.lang.Long")) {
                return Long.valueOf(parameter);
            }
            if (typeName.equals("float") || typeName.equals("java.lang.Float")) {
                return Float.valueOf(parameter);
            }
            if (typeName.equals("double") || typeName.equals("java.lang.Double")) {
                return Double.valueOf(parameter);
            }
            if (typeName.equals("java.math.BigDecimal")) {
                return new BigDecimal(parameter);
            }
            if (typeName.equals("java.math.BigInteger")) {
                return new BigInteger(parameter);
            }
            if (typeName.equals("boolean") || typeName.equals("java.lang.Boolean")) {
                return Boolean.valueOf(parameter);
            }
            if (typeName.equals("java.util.Properties") && (p = this.stringToProperties(parameter)) != null) {
                return p;
            }
            return parameter;
        }
        catch (NumberFormatException nfe) {
            _logger.log(Level.SEVERE, "jdbc.exc_nfe", parameter);
            String msg = sm.getString("me.invalid_param", (Object)parameter);
            throw new ResourceException(msg);
        }
    }

    public Object invokeMethod(Object object, String methodName, Class<?>[] valueTypes, Object ... values) throws ResourceException {
        Method actualMethod;
        Object returnValue = null;
        try {
            actualMethod = object.getClass().getMethod(methodName, valueTypes);
        }
        catch (NoSuchMethodException ex) {
            throw new ResourceException((Throwable)ex);
        }
        catch (SecurityException ex) {
            throw new ResourceException((Throwable)ex);
        }
        if (actualMethod != null) {
            try {
                returnValue = AccessController.doPrivileged(() -> {
                    actualMethod.setAccessible(true);
                    return actualMethod.invoke(object, values);
                });
            }
            catch (PrivilegedActionException e) {
                if (e.getException() != null) {
                    throw new ResourceException((Throwable)e.getException());
                }
                throw new ResourceException((Throwable)e);
            }
        }
        return returnValue;
    }

    private Properties stringToProperties(String parameter) {
        if (parameter == null) {
            return null;
        }
        String s = parameter.trim();
        if (!s.startsWith("(") || !s.endsWith(")")) {
            return null;
        }
        s = s.substring(1, s.length() - 1);
        s = s.replaceAll("(?<!\\\\),", newline);
        s = s.replaceAll("\\\\,", ",");
        Properties p = new Properties();
        Properties prop = new Properties();
        try {
            p.load(new StringBufferInputStream(s));
        }
        catch (IOException ex) {
            if (_logger.isLoggable(Level.FINEST)) {
                _logger.log(Level.FINEST, "Parsing string to properties: {0}", ex.getMessage());
            }
            return null;
        }
        Enumeration<?> propKeys = p.propertyNames();
        while (propKeys.hasMoreElements()) {
            String tmpKey = (String)propKeys.nextElement();
            String tmpValue = p.getProperty(tmpKey);
            if ((tmpValue = tmpValue.trim()).length() > 1 && tmpValue.startsWith("\"") && tmpValue.endsWith("\"")) {
                tmpValue = tmpValue.substring(1, tmpValue.length() - 1);
            }
            prop.put(tmpKey, tmpValue);
        }
        if (_logger.isLoggable(Level.FINEST)) {
            _logger.log(Level.FINEST, "Parsing string to properties: {0}size:{1}", new Object[]{prop, prop.size()});
        }
        return prop;
    }
}

