/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.admin.mejb;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.Naming;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.management.ListenerNotFoundException;
import javax.management.Notification;
import javax.management.NotificationListener;
import org.glassfish.admin.mejb.RemoteEventListener;

public class EventListenerProxy
extends UnicastRemoteObject
implements RemoteEventListener {
    private Hashtable listenerTable = new Hashtable();
    private Hashtable handbackTable = new Hashtable();
    private String proxyAddress;
    private static EventListenerProxy eventProxy = null;
    private static int portnum = 1100;
    private String rmiName = "RemoteEventListener" + this.hashCode() + System.currentTimeMillis();
    private static boolean debug = false;

    public static synchronized EventListenerProxy getEventListenerProxy() {
        block10: {
            if (eventProxy == null) {
                EventListenerProxy newProxy = null;
                try {
                    newProxy = new EventListenerProxy();
                    Naming.rebind(newProxy.proxyAddress, newProxy);
                    eventProxy = newProxy;
                    if (debug) {
                        System.out.println(EventListenerProxy.eventProxy.rmiName + " bound to existing registry at port " + portnum);
                    }
                }
                catch (RemoteException re) {
                    if (debug) {
                        System.out.println("Naming.rebind(" + (newProxy != null ? newProxy.proxyAddress : "null") + ", eventProxy): " + re);
                    }
                    try {
                        newProxy = new EventListenerProxy();
                        Registry r = LocateRegistry.createRegistry(portnum);
                        r.bind(newProxy.rmiName, newProxy);
                        eventProxy = newProxy;
                        if (debug) {
                            System.out.println(newProxy.rmiName + " bound to newly created registry at port " + portnum);
                        }
                    }
                    catch (Exception e) {
                        eventProxy = null;
                        if (debug) {
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    if (!debug) break block10;
                    e.printStackTrace();
                }
            }
        }
        return eventProxy;
    }

    public EventListenerProxy() throws RemoteException {
        String hostName;
        try {
            hostName = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostName = "localhost";
            System.out.println(e);
        }
        this.proxyAddress = "//" + hostName + ":" + portnum + "/" + this.rmiName;
    }

    @Override
    public void handleNotification(Notification n, Object h) throws RemoteException {
        NotificationListener listener;
        if (debug) {
            System.out.println("EventListenerProxy:handleNotification(" + n + ")");
        }
        if ((listener = (NotificationListener)this.listenerTable.get((String)h)) != null) {
            Object handback = this.handbackTable.get((String)h);
            listener.handleNotification(n, handback);
        } else {
            System.out.println("EventListenerProxy: listener id " + h + " not found");
        }
    }

    public String getProxyAddress() {
        return this.proxyAddress;
    }

    public void addListener(String id, NotificationListener l, Object handback) {
        if (debug) {
            System.out.println("EventListenerProxy.addListener()");
        }
        this.listenerTable.put(id, l);
        this.handbackTable.put(id, handback);
    }

    public void removeListener(String id) throws ListenerNotFoundException {
        if (this.listenerTable.remove(id) == null) {
            throw new ListenerNotFoundException();
        }
        this.handbackTable.remove(id);
    }
}

