/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.data;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.core.PacketReference;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class TransactionWorkMessage {
    private DestinationUID destUID;
    private Packet message;
    private ConsumerUID[] storedInterests;
    private PacketReference packetRef;

    public TransactionWorkMessage(DestinationUID destUID, Packet message, ConsumerUID[] storedInterests) {
        this.destUID = destUID;
        this.message = message;
        this.storedInterests = storedInterests;
    }

    public TransactionWorkMessage() {
    }

    public DestinationUID getDestUID() {
        return this.destUID;
    }

    public void setDestUID(DestinationUID destUID) {
        this.destUID = destUID;
    }

    public Packet getMessage() {
        return this.message;
    }

    public PacketReference getPacketReference() {
        return this.packetRef;
    }

    public void setPacketReference(PacketReference ref) {
        this.packetRef = ref;
        this.message = ref.getPacket();
    }

    public String toString() {
        StringBuffer result = new StringBuffer("sysMessageID=").append(this.message.getMessageID());
        result.append(" destUID=").append(this.destUID);
        result.append(" dest=").append(this.message.getDestination());
        return result.toString();
    }

    public ConsumerUID[] getStoredInterests() {
        return this.storedInterests;
    }

    public void setStoredInterests(ConsumerUID[] storedInterests) {
        this.storedInterests = storedInterests;
    }

    public void writeWork(DataOutputStream dos) throws IOException {
        byte[] data = this.getMessage().getBytes();
        dos.write(data);
        ConsumerUID[] storedInterests = this.getStoredInterests();
        if (storedInterests == null) {
            dos.writeInt(0);
        } else {
            dos.writeInt(storedInterests.length);
            for (int i = 0; i < storedInterests.length; ++i) {
                dos.writeLong(storedInterests[i].longValue());
            }
        }
    }

    public void readWork(DataInputStream dis) throws IOException, BrokerException {
        this.message = new Packet(false);
        this.message.generateTimestamp(false);
        this.message.generateSequenceNumber(false);
        this.message.readPacket((InputStream)dis);
        int numStoredInterests = dis.readInt();
        this.storedInterests = new ConsumerUID[numStoredInterests];
        for (int j = 0; j < numStoredInterests; ++j) {
            long cuid = dis.readLong();
            this.storedInterests[j] = new ConsumerUID(cuid);
        }
        this.destUID = DestinationUID.getUID(this.message.getDestination(), this.message.getIsQueue());
    }
}

