# Jakarta EE Calculator Application

## 📋 Description

Application web de calcul arithmétique développée avec **Jakarta EE 10** (Servlet API 6.0) et **Java 21**, déployable sur **Apache Tomcat 10.1+**.

## ✨ Fonctionnalités

La servlet `CalculationServlet` propose les opérations suivantes via la méthode GET :

- ➕ **Addition** : nombre1 + nombre2
- ➖ **Soustraction** : nombre1 - nombre2
- ✖️ **Multiplication** : nombre1 × nombre2
- ➗ **Division** : nombre1 ÷ nombre2 (avec gestion de la division par zéro)

## 🛠️ Technologies Utilisées

- **Java 21**
- **Jakarta EE 10** (Servlet API 6.0)
- **Maven 3.x**
- **Apache Tomcat 10.1+** (compatible Jakarta EE 10)

## 📦 Prérequis

- Java Development Kit (JDK) 21 ou supérieur
- Apache Maven 3.6+
- Apache Tomcat 10.1+ (pour Jakarta EE 10)

## 🚀 Compilation du Projet

```bash
mvn clean package
```

Cette commande génère le fichier WAR dans le répertoire `target/jakarta-calculator.war`

## 📥 Déploiement sur Tomcat

### Méthode 1 : Déploiement Manuel

1. Copiez le fichier `target/jakarta-calculator.war` dans le répertoire `webapps/` de Tomcat
2. Démarrez Tomcat :
   ```bash
   # Linux/Mac
   $CATALINA_HOME/bin/startup.sh
   
   # Windows
   %CATALINA_HOME%\bin\startup.bat
   ```
3. Accédez à l'application via : `http://localhost:8080/jakarta-calculator`

### Méthode 2 : Via le Manager de Tomcat

1. Accédez au Tomcat Manager : `http://localhost:8080/manager/html`
2. Dans la section "WAR file to deploy", sélectionnez `jakarta-calculator.war`
3. Cliquez sur "Deploy"

## 🔗 Utilisation

### Interface Web

Accédez à l'application : `http://localhost:8080/jakarta-calculator`

### URL de la Servlet

```
http://localhost:8080/jakarta-calculator/calculate
```

### Paramètres GET

- `nombre1` : Premier entier (obligatoire)
- `nombre2` : Deuxième entier (obligatoire)
- `operation` : Type d'opération (obligatoire)
  - Valeurs acceptées : `addition`, `soustraction`, `multiplication`, `division`
  - Alias acceptés : `add`, `sub`, `mul`, `div`, `+`, `-`, `*`, `/`

### Exemples d'Utilisation

```
# Addition : 10 + 5 = 15
http://localhost:8080/jakarta-calculator/calculate?nombre1=10&nombre2=5&operation=addition

# Soustraction : 20 - 8 = 12
http://localhost:8080/jakarta-calculator/calculate?nombre1=20&nombre2=8&operation=soustraction

# Multiplication : 7 × 6 = 42
http://localhost:8080/jakarta-calculator/calculate?nombre1=7&nombre2=6&operation=multiplication

# Division : 100 ÷ 4 = 25.00
http://localhost:8080/jakarta-calculator/calculate?nombre1=100&nombre2=4&operation=division
```

## 📁 Structure du Projet

```
jakarta-calculator-app/
├── pom.xml
├── README.md
└── src/
    └── main/
        ├── java/
        │   └── com/
        │       └── example/
        │           └── servlet/
        │               └── CalculationServlet.java
        └── webapp/
            ├── WEB-INF/
            │   └── web.xml
            └── index.html
```

## 🔍 Points Techniques

### Utilisation de Java 21

La servlet utilise les fonctionnalités modernes de Java 21 :
- **Switch Expressions** pour les opérations arithmétiques
- **Pattern Matching** pour une meilleure lisibilité
- **Try-with-resources** pour la gestion automatique des ressources

### Annotations Jakarta EE

```java
@WebServlet(name = "CalculationServlet", urlPatterns = {"/calculate"})
```

Cette annotation permet la configuration de la servlet sans nécessiter de déclaration dans `web.xml`.

### Gestion des Erreurs

- Validation des paramètres d'entrée
- Gestion de la division par zéro
- Gestion des nombres invalides (NumberFormatException)
- Messages d'erreur clairs pour l'utilisateur

## 🐛 Dépannage

### Erreur 404 - Servlet non trouvée

Vérifiez que :
- Le fichier WAR est correctement déployé dans `webapps/`
- Tomcat est démarré
- L'URL contient le bon contexte : `/jakarta-calculator/calculate`

### Erreur de compatibilité Jakarta EE

Assurez-vous d'utiliser :
- **Tomcat 10.1+** pour Jakarta EE 10
- **Java 21** comme version du JDK

### Problèmes de compilation Maven

```bash
# Nettoyer et recompiler
mvn clean compile
mvn clean package
```

## 📄 Licence

Ce projet est un exemple éducatif pour démontrer l'utilisation de Jakarta EE Servlet avec Java 21.

## 👨‍💻 Auteur

Développé pour démontrer les capacités de Jakarta EE 10 avec Java 21 sur Apache Tomcat.

---

**Note** : Ce projet nécessite Tomcat 10.1+ car il utilise Jakarta EE 10 (namespace `jakarta.*` au lieu de `javax.*`).
