package com.formation.jakarta.servlets;

import com.formation.jakarta.calcul.Calculation;
import com.formation.jakarta.calcul.ICalculation;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;

import java.io.IOException;
import java.io.PrintWriter;

/**
 * Servlet de calcul arithmétique Supporte les opérations: addition, soustraction, multiplication et division
 */
@WebServlet( name = "CalculationServlet", urlPatterns = { "/calculate" } )
public class CalculationServlet extends HttpServlet
{
    private ICalculation calculation;

    @Override
    public void init( ServletConfig config )
    {
        calculation = new Calculation( );
    }

    @Override
    protected void doGet( HttpServletRequest request, HttpServletResponse response ) throws IOException
    {
        response.setContentType( "text/html;charset=UTF-8" );
        try ( PrintWriter out = response.getWriter( ) )
        {
            // Récupération des paramètres
            String nombre1Str = request.getParameter( "nombre1" );
            String nombre2Str = request.getParameter( "nombre2" );
            String operation = request.getParameter( "operation" );
            // Validation des paramètres
            if ( nombre1Str == null || nombre2Str == null || operation == null )
            {
                afficherFormulaire( out, null );
                return;
            }
            try
            {
                int nombre1 = Integer.parseInt( nombre1Str );
                int nombre2 = Integer.parseInt( nombre2Str );

                String result = switch( operation.toLowerCase( ) )
                {
                    case "addition", "add", "+" ->
                    {
                        int somme = calculation.addition( nombre1, nombre2 );
                        yield String.format( "%d + %d = %d", nombre1, nombre2, somme );
                    }
                    case "soustraction", "sub", "-" ->
                    {
                        int difference = calculation.soustraction( nombre1, nombre2 );
                        yield String.format( "%d - %d = %d", nombre1, nombre2, difference );
                    }
                    case "multiplication", "mul", "*" ->
                    {
                        int produit = calculation.multiply( nombre1, nombre2 );
                        yield String.format( "%d × %d = %d", nombre1, nombre2, produit );
                    }
                    case "division", "div", "/" ->
                    {
                        if ( nombre2 == 0 )
                        {
                            yield "Erreur: Division par zéro impossible";
                        }
                        double quotient = calculation.divide( nombre1, nombre2 );
                        ;
                        yield String.format( "%d ÷ %d = %.2f", nombre1, nombre2, quotient );
                    }
                    default -> "Opération non reconnue. Utilisez: addition, soustraction, multiplication ou division";
                };
                afficherFormulaire( out, result );
            }
            catch( NumberFormatException e )
            {
                afficherFormulaire( out, "Erreur: Veuillez entrer des nombres entiers valides" );
            }
        }
    }

    private void afficherFormulaire( PrintWriter out, String result )
    {
        out.println( "<!DOCTYPE html>" );
        out.println( "<html lang='fr'>" );
        out.println( "<head>" );
        out.println( "    <meta charset='UTF-8'>" );
        out.println( "    <meta name='viewport' content='width=device-width, initial-scale=1.0'>" );
        out.println( "    <title>Calculatrice Jakarta EE</title>" );
        out.println( "    <style>" );
        out.println( "        body {" );
        out.println( "            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;" );
        out.println( "            max-width: 600px;" );
        out.println( "            margin: 50px auto;" );
        out.println( "            padding: 20px;" );
        out.println( "            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);" );
        out.println( "            min-height: 100vh;" );
        out.println( "        }" );
        out.println( "        .container {" );
        out.println( "            background: white;" );
        out.println( "            padding: 30px;" );
        out.println( "            border-radius: 15px;" );
        out.println( "            box-shadow: 0 10px 25px rgba(0,0,0,0.2);" );
        out.println( "        }" );
        out.println( "        h1 {" );
        out.println( "            color: #667eea;" );
        out.println( "            text-align: center;" );
        out.println( "            margin-bottom: 30px;" );
        out.println( "        }" );
        out.println( "        .form-group {" );
        out.println( "            margin-bottom: 20px;" );
        out.println( "        }" );
        out.println( "        label {" );
        out.println( "            display: block;" );
        out.println( "            margin-bottom: 8px;" );
        out.println( "            color: #333;" );
        out.println( "            font-weight: 600;" );
        out.println( "        }" );
        out.println( "        input[type='number'], select {" );
        out.println( "            width: 100%;" );
        out.println( "            padding: 12px;" );
        out.println( "            border: 2px solid #e0e0e0;" );
        out.println( "            border-radius: 8px;" );
        out.println( "            font-size: 16px;" );
        out.println( "            box-sizing: border-box;" );
        out.println( "            transition: border-color 0.3s;" );
        out.println( "        }" );
        out.println( "        input[type='number']:focus, select:focus {" );
        out.println( "            outline: none;" );
        out.println( "            border-color: #667eea;" );
        out.println( "        }" );
        out.println( "        button {" );
        out.println( "            width: 100%;" );
        out.println( "            padding: 14px;" );
        out.println( "            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);" );
        out.println( "            color: white;" );
        out.println( "            border: none;" );
        out.println( "            border-radius: 8px;" );
        out.println( "            font-size: 18px;" );
        out.println( "            font-weight: 600;" );
        out.println( "            cursor: pointer;" );
        out.println( "            transition: transform 0.2s;" );
        out.println( "        }" );
        out.println( "        button:hover {" );
        out.println( "            transform: translateY(-2px);" );
        out.println( "        }" );
        out.println( "        .result {" );
        out.println( "            margin-top: 25px;" );
        out.println( "            padding: 20px;" );
        out.println( "            background: #f0f7ff;" );
        out.println( "            border-left: 4px solid #667eea;" );
        out.println( "            border-radius: 8px;" );
        out.println( "            font-size: 20px;" );
        out.println( "            font-weight: 600;" );
        out.println( "            color: #333;" );
        out.println( "        }" );
        out.println( "        .error {" );
        out.println( "            background: #ffe0e0;" );
        out.println( "            border-left-color: #f44336;" );
        out.println( "            color: #c62828;" );
        out.println( "        }" );
        out.println( "        .operations {" );
        out.println( "            display: grid;" );
        out.println( "            grid-template-columns: repeat(2, 1fr);" );
        out.println( "            gap: 10px;" );
        out.println( "            margin-top: 10px;" );
        out.println( "        }" );
        out.println( "        .op-btn {" );
        out.println( "            padding: 10px;" );
        out.println( "            background: #f5f5f5;" );
        out.println( "            border: 2px solid #e0e0e0;" );
        out.println( "            border-radius: 8px;" );
        out.println( "            cursor: pointer;" );
        out.println( "            transition: all 0.2s;" );
        out.println( "        }" );
        out.println( "        .op-btn:hover {" );
        out.println( "            background: #667eea;" );
        out.println( "            color: white;" );
        out.println( "            border-color: #667eea;" );
        out.println( "        }" );
        out.println( "        .footer {" );
        out.println( "            margin-top: 20px;" );
        out.println( "            text-align: center;" );
        out.println( "            color: #666;" );
        out.println( "            font-size: 14px;" );
        out.println( "        }" );
        out.println( "    </style>" );
        out.println( "</head>" );
        out.println( "<body>" );
        out.println( "    <div class='container'>" );
        out.println( "        <h1>🧮 Calculatrice Jakarta EE</h1>" );
        out.println( "        <form method='GET' action='calculate'>" );
        out.println( "            <div class='form-group'>" );
        out.println( "                <label for='nombre1'>Premier nombre (nombre1):</label>" );
        out.println( "                <input type='number' id='nombre1' name='nombre1' required>" );
        out.println( "            </div>" );
        out.println( "            <div class='form-group'>" );
        out.println( "                <label for='nombre2'>Deuxième nombre (nombre2):</label>" );
        out.println( "                <input type='number' id='nombre2' name='nombre2' required>" );
        out.println( "            </div>" );
        out.println( "            <div class='form-group'>" );
        out.println( "                <label for='operation'>Opération:</label>" );
        out.println( "                <select id='operation' name='operation' required>" );
        out.println( "                    <option value='addition'>➕ Addition</option>" );
        out.println( "                    <option value='soustraction'>➖ Soustraction</option>" );
        out.println( "                    <option value='multiplication'>✖️ Multiplication</option>" );
        out.println( "                    <option value='division'>➗ Division</option>" );
        out.println( "                </select>" );
        out.println( "            </div>" );
        out.println( "            <button type='submit'>Calculer</button>" );
        out.println( "        </form>" );

        if ( result != null )
        {
            String cssClass = result.startsWith( "Erreur" ) ? "result error" : "result";
            out.println( "        <div class='" + cssClass + "'>" );
            out.println( "            " + result );
            out.println( "        </div>" );
        }

        out.println( "        <div class='footer'>" );
        out.println(
                "            <p>Jakarta EE " + getServletContext( ).getMajorVersion( ) + "." + getServletContext( ).getMinorVersion( ) + " | Java " + System.getProperty(
                        "java.version" ) + "</p>" );
        out.println( "        </div>" );
        out.println( "    </div>" );
        out.println( "</body>" );
        out.println( "</html>" );
    }

    @Override
    public String getServletInfo( )
    {
        return "Servlet de calcul arithmétique - Jakarta EE";
    }
}
