/*
 * Decompiled with CFR 0.152.
 */
package com.training.controller;

import com.training.controller.PersonApi;
import com.training.controller.PersonController;
import com.training.controller.PersonMapper;
import com.training.entities.Person;
import com.training.exceptions.ManagePeoplesException;
import com.training.service.IPersonService;
import jakarta.validation.Valid;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/persons"})
public class PersonController {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonController.class);
    private final IPersonService personService;

    @PostMapping
    public ResponseEntity<PersonApi> createPerson(@Valid @RequestBody PersonApi personApi) {
        log.info("POST /api/persons - Cr\u00e9ation d'une personne: {} {}", (Object)personApi.getFirstName(), (Object)personApi.getLastName());
        Person person = PersonMapper.toEntity((PersonApi)personApi);
        Person createdPerson = this.personService.createPerson(person);
        PersonApi response = PersonMapper.toApi((Person)createdPerson);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)response);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<PersonApi> getPersonById(@PathVariable Integer id) {
        log.info("GET /api/persons/{} - R\u00e9cup\u00e9ration d'une personne", (Object)id);
        return this.personService.getPersonById(id).map(PersonMapper::toApi).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping
    public ResponseEntity<List<PersonApi>> getAllPersons() {
        log.info("GET /api/persons - R\u00e9cup\u00e9ration de toutes les personnes");
        List persons = this.personService.getAllPersons().stream().map(PersonMapper::toApi).collect(Collectors.toList());
        return ResponseEntity.ok(persons);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<PersonApi> updatePerson(@PathVariable Integer id, @Valid @RequestBody PersonApi personApi) {
        log.info("PUT /api/persons/{} - Mise \u00e0 jour d'une personne", (Object)id);
        Person person = PersonMapper.toEntity((PersonApi)personApi);
        Person updatedPerson = this.personService.updatePerson(id, person);
        PersonApi response = PersonMapper.toApi((Person)updatedPerson);
        return ResponseEntity.ok((Object)response);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deletePerson(@PathVariable Integer id) {
        log.info("DELETE /api/persons/{} - Suppression d'une personne", (Object)id);
        this.personService.deletePerson(id);
        return ResponseEntity.noContent().build();
    }

    @GetMapping(value={"/search"})
    public ResponseEntity<PersonApi> findByFirstNameAndLastName(@RequestParam String firstName, @RequestParam String lastName) {
        log.info("GET /api/persons/search?firstName={}&lastName={}", (Object)firstName, (Object)lastName);
        return this.personService.findByFirstNameAndLastName(firstName, lastName).map(PersonMapper::toApi).map(ResponseEntity::ok).orElse(ResponseEntity.notFound().build());
    }

    @GetMapping(value={"/city/{city}"})
    public ResponseEntity<List<PersonApi>> findByCity(@PathVariable String city) {
        log.info("GET /api/persons/city/{}", (Object)city);
        List persons = this.personService.findByCity(city).stream().map(PersonMapper::toApi).collect(Collectors.toList());
        return ResponseEntity.ok(persons);
    }

    @GetMapping(value={"/country/{country}"})
    public ResponseEntity<List<PersonApi>> findByCountry(@PathVariable String country) {
        log.info("GET /api/persons/country/{}", (Object)country);
        List persons = this.personService.findByCountry(country).stream().map(PersonMapper::toApi).collect(Collectors.toList());
        return ResponseEntity.ok(persons);
    }

    @ExceptionHandler(value={ManagePeoplesException.class})
    public ResponseEntity<ErrorResponse> handleManagePeoplesException(ManagePeoplesException ex) {
        log.error("Erreur m\u00e9tier: {}", (Object)ex.getMessage());
        ErrorResponse error = new ErrorResponse(ex.getMessage());
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).body((Object)error);
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<ErrorResponse> handleException(Exception ex) {
        log.error("Erreur interne: {}", (Object)ex.getMessage(), (Object)ex);
        ErrorResponse error = new ErrorResponse("Erreur interne du serveur");
        return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)error);
    }

    @Generated
    public PersonController(IPersonService personService) {
        this.personService = personService;
    }
}

