/*
 * Decompiled with CFR 0.152.
 */
package com.training.service;

import com.training.entities.Person;
import com.training.exceptions.ManagePeoplesException;
import com.training.repository.PersonJpaRepository;
import com.training.service.IPersonService;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PersonService
implements IPersonService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PersonService.class);
    private final PersonJpaRepository personRepository;

    @Transactional
    public Person createPerson(Person person) {
        try {
            log.info("Cr\u00e9ation d'une nouvelle personne: {} {}", (Object)person.getFirstName(), (Object)person.getLastName());
            if (person.getId() != null) {
                throw new ManagePeoplesException("L'ID doit \u00eatre null lors de la cr\u00e9ation d'une personne");
            }
            Person savedPerson = (Person)this.personRepository.save((Object)person);
            log.info("Personne cr\u00e9\u00e9e avec succ\u00e8s avec l'ID: {}", (Object)savedPerson.getId());
            return savedPerson;
        }
        catch (Exception e) {
            log.error("Erreur lors de la cr\u00e9ation de la personne", (Throwable)e);
            throw new ManagePeoplesException("Erreur lors de la cr\u00e9ation de la personne: " + e.getMessage(), (Throwable)e);
        }
    }

    public Optional<Person> getPersonById(Integer id) {
        try {
            log.info("Recherche de la personne avec l'ID: {}", (Object)id);
            return this.personRepository.findById((Object)id);
        }
        catch (Exception e) {
            log.error("Erreur lors de la r\u00e9cup\u00e9ration de la personne avec l'ID: {}", (Object)id, (Object)e);
            throw new ManagePeoplesException("Erreur lors de la r\u00e9cup\u00e9ration de la personne: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Person> getAllPersons() {
        try {
            log.info("R\u00e9cup\u00e9ration de toutes les personnes");
            List persons = this.personRepository.findAll();
            log.info("Nombre de personnes trouv\u00e9es: {}", (Object)persons.size());
            return persons;
        }
        catch (Exception e) {
            log.error("Erreur lors de la r\u00e9cup\u00e9ration de toutes les personnes", (Throwable)e);
            throw new ManagePeoplesException("Erreur lors de la r\u00e9cup\u00e9ration des personnes: " + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    public Person updatePerson(Integer id, Person person) {
        try {
            log.info("Mise \u00e0 jour de la personne avec l'ID: {}", (Object)id);
            Person existingPerson = (Person)this.personRepository.findById((Object)id).orElseThrow(() -> new ManagePeoplesException("Personne non trouv\u00e9e avec l'ID: " + id));
            existingPerson.setFirstName(person.getFirstName());
            existingPerson.setLastName(person.getLastName());
            existingPerson.setWeight(person.getWeight());
            existingPerson.setSize(person.getSize());
            existingPerson.setStreet(person.getStreet());
            existingPerson.setPostalCode(person.getPostalCode());
            existingPerson.setCity(person.getCity());
            existingPerson.setCountry(person.getCountry());
            Person updatedPerson = (Person)this.personRepository.save((Object)existingPerson);
            log.info("Personne mise \u00e0 jour avec succ\u00e8s: {}", (Object)updatedPerson.getId());
            return updatedPerson;
        }
        catch (ManagePeoplesException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Erreur lors de la mise \u00e0 jour de la personne avec l'ID: {}", (Object)id, (Object)e);
            throw new ManagePeoplesException("Erreur lors de la mise \u00e0 jour de la personne: " + e.getMessage(), (Throwable)e);
        }
    }

    @Transactional
    public void deletePerson(Integer id) {
        try {
            log.info("Suppression de la personne avec l'ID: {}", (Object)id);
            if (!this.personRepository.existsById((Object)id)) {
                throw new ManagePeoplesException("Personne non trouv\u00e9e avec l'ID: " + id);
            }
            this.personRepository.deleteById((Object)id);
            log.info("Personne supprim\u00e9e avec succ\u00e8s: {}", (Object)id);
        }
        catch (ManagePeoplesException e) {
            throw e;
        }
        catch (Exception e) {
            log.error("Erreur lors de la suppression de la personne avec l'ID: {}", (Object)id, (Object)e);
            throw new ManagePeoplesException("Erreur lors de la suppression de la personne: " + e.getMessage(), (Throwable)e);
        }
    }

    public Optional<Person> findByFirstNameAndLastName(String firstName, String lastName) {
        try {
            log.info("Recherche de la personne: {} {}", (Object)firstName, (Object)lastName);
            return this.personRepository.findByFirstNameAndLastName(firstName, lastName);
        }
        catch (Exception e) {
            log.error("Erreur lors de la recherche de la personne: {} {}", new Object[]{firstName, lastName, e});
            throw new ManagePeoplesException("Erreur lors de la recherche de la personne: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Person> findByCity(String city) {
        try {
            log.info("Recherche des personnes dans la ville: {}", (Object)city);
            return this.personRepository.findByCity(city);
        }
        catch (Exception e) {
            log.error("Erreur lors de la recherche des personnes dans la ville: {}", (Object)city, (Object)e);
            throw new ManagePeoplesException("Erreur lors de la recherche par ville: " + e.getMessage(), (Throwable)e);
        }
    }

    public List<Person> findByCountry(String country) {
        try {
            log.info("Recherche des personnes dans le pays: {}", (Object)country);
            return this.personRepository.findByCountry(country);
        }
        catch (Exception e) {
            log.error("Erreur lors de la recherche des personnes dans le pays: {}", (Object)country, (Object)e);
            throw new ManagePeoplesException("Erreur lors de la recherche par pays: " + e.getMessage(), (Throwable)e);
        }
    }

    @Generated
    public PersonService(PersonJpaRepository personRepository) {
        this.personRepository = personRepository;
    }
}

