package com.training.repository;

import com.training.entities.Person;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.stereotype.Repository;

import java.util.List;
import java.util.Optional;

@Repository
public interface PersonJpaRepository extends JpaRepository<Person, Integer> {

    /**
     * Recherche une personne par son prénom et nom
     */
    Optional<Person> findByFirstNameAndLastName(String firstName, String lastName);

    /**
     * Recherche toutes les personnes par ville
     */
    List<Person> findByCity(String city);

    /**
     * Recherche toutes les personnes par pays
     */
    List<Person> findByCountry(String country);

    /**
     * Recherche toutes les personnes par nom (case insensitive)
     */
    List<Person> findByLastNameIgnoreCase(String lastName);
}