package com.training.service;

import com.training.entities.Person;

import java.util.List;
import java.util.Optional;

/**
 * Interface du service de gestion des personnes
 */
public interface IPersonService {

    /**
     * Créer une nouvelle personne
     * @param person la personne à créer
     * @return la personne créée avec son ID
     */
    Person createPerson(Person person);

    /**
     * Récupérer une personne par son ID
     * @param id l'identifiant de la personne
     * @return Optional contenant la personne si trouvée
     */
    Optional<Person> getPersonById(Integer id);

    /**
     * Récupérer toutes les personnes
     * @return la liste de toutes les personnes
     */
    List<Person> getAllPersons();

    /**
     * Mettre à jour une personne existante
     * @param id l'identifiant de la personne à mettre à jour
     * @param person les nouvelles données
     * @return la personne mise à jour
     */
    Person updatePerson(Integer id, Person person);

    /**
     * Supprimer une personne par son ID
     * @param id l'identifiant de la personne à supprimer
     */
    void deletePerson(Integer id);

    /**
     * Rechercher une personne par prénom et nom
     * @param firstName le prénom
     * @param lastName le nom
     * @return Optional contenant la personne si trouvée
     */
    Optional<Person> findByFirstNameAndLastName(String firstName, String lastName);

    /**
     * Rechercher toutes les personnes par ville
     * @param city la ville
     * @return la liste des personnes habitant dans cette ville
     */
    List<Person> findByCity(String city);

    /**
     * Rechercher toutes les personnes par pays
     * @param country le pays
     * @return la liste des personnes habitant dans ce pays
     */
    List<Person> findByCountry(String country);
}
