/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.file;

import com.sun.messaging.jmq.io.disk.VRFileRAF;
import com.sun.messaging.jmq.io.disk.VRFileWarning;
import com.sun.messaging.jmq.io.disk.VRecordRAF;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.data.BaseTransaction;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.api.Store;
import com.sun.messaging.jmq.jmsserver.persist.file.MsgStore;
import com.sun.messaging.jmq.jmsserver.persist.file.RandomAccessStore;
import com.sun.messaging.jmq.jmsserver.persist.file.TransactionWorkInfo;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;

class PreparedTxnStore
extends RandomAccessStore {
    BrokerConfig config = Globals.getConfig();
    static final String USE_FILE_CHANNEL_PROP = "imq.persist.file.message.use_file_channel";
    static String VRFILE_NAME = "vrfile";
    String storeName = "incompleteTxnStore";
    private ConcurrentHashMap<TransactionUID, TransactionWorkInfo> transactionMap = new ConcurrentHashMap(1000);
    private AtomicBoolean loaded = new AtomicBoolean(false);
    protected float growthFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.growth_factor", 0.5f);
    protected long threshold = this.config.getLongProperty("imq.persist.file.message.vrfile.threshold", 0L);
    protected float thresholdFactor = this.config.getPercentageProperty("imq.persist.file.message.vrfile.threshold_factor", 0.0f);
    private static FilenameFilter vrfileFilter = new FilenameFilter(){

        @Override
        public boolean accept(File dir, String name) {
            return !name.equals(VRFILE_NAME);
        }
    };
    private static Enumeration emptyEnum = new Enumeration(){

        @Override
        public boolean hasMoreElements() {
            return false;
        }

        public Object nextElement() {
            return null;
        }
    };
    private int txnCount = 0;
    private long byteCount = 0L;
    private Object countLock = new Object();
    private VRFileRAF vrfile = null;
    int maxRecordSize = 0;

    PreparedTxnStore(MsgStore p, File dir, boolean load) throws BrokerException {
        super(dir, p.msgfdlimit, p.poollimit, p.cleanratio);
        try {
            long fsize = p.initialFileSize.getBytes();
            if (fsize > 0L) {
                this.maxRecordSize = (int)p.maxRecordSize.getBytes();
                this.vrfile = new VRFileRAF(new File(dir, VRFILE_NAME), fsize, Globals.isMinimumWritesFileStore(), Broker.isInProcess());
                this.vrfile.setBlockSize(p.blockSize);
                try {
                    this.vrfile.setGrowthFactor(this.growthFactor);
                }
                catch (IllegalArgumentException iiEx) {
                    this.vrfile.setGrowthFactor(0.5f);
                    this.growthFactor = 0.5f;
                    this.logger.log(8, "Invalid growth_factor value. Using default value of 50%.");
                }
                try {
                    this.vrfile.setThreshold(this.threshold);
                }
                catch (IllegalArgumentException iiEx) {
                    this.vrfile.setThreshold(0L);
                    this.threshold = 0L;
                    this.logger.log(8, "Invalid threshold value. Using default value of 0.");
                }
                try {
                    this.vrfile.setThresholdFactor(this.thresholdFactor);
                }
                catch (IllegalArgumentException iiEx) {
                    this.vrfile.setThresholdFactor(0.0f);
                    this.thresholdFactor = 0.0f;
                    this.logger.log(8, "Invalid threshold_factor value. Using default value of 0%.");
                }
                try {
                    if (this.threshold != 0L || this.thresholdFactor != 0.0f) {
                        this.vrfile.checkGrowthFactorSanity();
                    }
                }
                catch (IllegalStateException isEx) {
                    String exMsg = isEx.getMessage();
                    this.logger.log(8, exMsg);
                }
                try {
                    this.vrfile.setCookie(1L);
                    this.vrfile.open();
                    long originalCookie = this.vrfile.getFileCookie();
                    if (originalCookie < 1L) {
                        String msg = "Existing file: " + this.storeName + "has older cookie version than current version. Current version = " + 1L + ". Original file version = " + originalCookie;
                        this.logger.log(16, msg);
                    } else if (originalCookie > 1L) {
                        String msg = "Existing file: " + this.storeName + " has newer cookie version than current version. Current version = " + 1L + ". Original file version = " + originalCookie;
                        this.logger.log(32, msg);
                    }
                }
                catch (VRFileWarning e) {
                    this.logger.log(16, "possible data loss for " + this.storeName, e);
                }
            }
            this.initCounts();
        }
        catch (IOException e) {
            this.logger.log(32, "failed to load " + this.storeName, e);
            throw new BrokerException("failed to load " + this.storeName, e);
        }
        catch (Throwable t) {
            this.logger.log(32, "failed to load " + this.storeName, t);
            throw new BrokerException("failed to load " + this.storeName, t);
        }
        if (load) {
            this.loadTransactions();
        }
    }

    public HashMap getStorageInfo() throws BrokerException {
        if (this.vrfile == null) {
            return new HashMap();
        }
        HashMap<String, Number> info = new HashMap<String, Number>(3);
        long used = this.vrfile.getBytesUsed();
        long free = this.vrfile.getBytesFree();
        info.put("diskUsed", used);
        info.put("diskReserved", used + free);
        info.put("diskUtilizationRatio", (int)(this.vrfile.getUtilizationRatio() * 100.0f));
        return info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compact() throws BrokerException {
        if (this.vrfile == null) {
            return;
        }
        VRFileRAF vRFileRAF = this.vrfile;
        synchronized (vRFileRAF) {
            try {
                this.vrfile.close();
                try {
                    this.vrfile.compact();
                }
                catch (VRFileWarning e) {
                    this.logger.log(16, "possible data loss for " + this.storeName, e);
                }
                try {
                    this.vrfile.open();
                }
                catch (VRFileWarning e) {
                    this.logger.log(16, "possible data loss for " + this.storeName, e);
                }
                this.transactionMap.clear();
                Iterator itr = this.vrfile.getRecords().iterator();
                TxnEnumeration e = new TxnEnumeration(this, itr, emptyEnum);
                while (e.hasMoreElements()) {
                    e.nextElement();
                }
            }
            catch (IOException e) {
                throw new BrokerException("Failed to compact file: " + this.vrfile.getFile(), e);
            }
        }
    }

    TransactionWorkInfo storeTransaction(BaseTransaction baseTxn, boolean sync) throws IOException, BrokerException {
        TransactionUID id = baseTxn.getTid();
        if (this.transactionMap.containsKey(id)) {
            String emsg = this.br.getKString("B3016", id) + ": " + this.storeName;
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        try {
            byte[] data = baseTxn.writeToBytes();
            int msgsize = data.length;
            if (sync && Store.getDEBUG_SYNC()) {
                String msg = " PreparedTxnStore storeTransaction sync " + baseTxn;
                Globals.getLogger().log(4, msg);
            }
            TransactionWorkInfo info = null;
            info = this.vrfile != null && (this.maxRecordSize == 0 || msgsize < this.maxRecordSize) ? new TransactionWorkInfo(this, this.vrfile, baseTxn, data, sync) : new TransactionWorkInfo(this, baseTxn, data, sync);
            this.transactionMap.put(info.getID(), info);
            this.incrTxnCount(msgsize);
            return info;
        }
        catch (IOException e) {
            this.logger.log(32, "B4004", (Object)id.toString(), (Throwable)e);
            throw e;
        }
    }

    void removeTransaction(TransactionUID id, boolean sync) throws BrokerException {
        TransactionWorkInfo oldmsg = this.transactionMap.remove(id);
        if (oldmsg == null) {
            String emsg = this.br.getKString("B3016", id) + ": " + this.storeName;
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        try {
            oldmsg.free(sync);
        }
        catch (IOException e) {
            throw new BrokerException("failed to free transaction", e);
        }
        this.decrTxnCount(oldmsg.getSize());
    }

    void removeAllTransactions(boolean sync) throws IOException, BrokerException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
        }
        this.removeAllData(sync);
        this.transactionMap.clear();
        this.clearCounts();
    }

    void releasePreparedTxnDir(boolean sync) throws IOException {
        if (this.vrfile != null) {
            this.vrfile.clear(false);
            this.vrfile.close();
            this.vrfile = null;
        }
        this.reset(true);
        super.close(false);
        this.transactionMap.clear();
        this.clearCounts();
    }

    Enumeration<BaseTransaction> txnEnumeration() {
        if (this.loaded.get()) {
            if (Store.getDEBUG()) {
                String msg = this.getPrefix() + " returning getTransactionIterator()";
                this.logger.log(4, msg);
            }
            return new TxnEnumeration(this, this.getTransactionIterator());
        }
        Iterator recitr = null;
        if (this.vrfile != null) {
            recitr = this.vrfile.getRecords().iterator();
        }
        if (Store.getDEBUG()) {
            String msg = this.getPrefix() + " returning getEnumeration()";
            this.logger.log(4, msg);
        }
        return new TxnEnumeration(this, recitr, this.getFileEnumeration());
    }

    int getTransactionCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "PreparedTxnStore:getTransactionCount() " + this.txnCount);
        }
        return this.txnCount;
    }

    long getByteCount() throws BrokerException {
        if (Store.getDEBUG()) {
            this.logger.log(4, "PreparedTxnStore:getByteCount()");
        }
        return this.byteCount;
    }

    @Override
    protected void close(boolean cleanup) {
        if (this.vrfile != null) {
            this.vrfile.close();
        }
        super.close(cleanup);
        this.transactionMap.clear();
    }

    VRFileRAF getVRFile() {
        return this.vrfile;
    }

    public void loadTransactions() throws BrokerException {
        Enumeration<BaseTransaction> e = this.txnEnumeration();
        while (e.hasMoreElements()) {
            e.nextElement();
        }
        this.logger.log(4, this.getPrefix() + " loaded " + this.transactionMap.size() + " transactions");
    }

    TransactionWorkInfo getTransactionInfo(TransactionUID tid) throws BrokerException {
        TransactionWorkInfo info = this.transactionMap.get(tid);
        if (info == null) {
            String emsg = this.br.getKString("B3016", tid) + ": " + this.storeName;
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return info;
    }

    @Override
    Object parseData(byte[] data, byte[] attachment) throws IOException {
        TransactionWorkInfo minfo = new TransactionWorkInfo(this, data, attachment);
        TransactionUID tid = minfo.getID();
        this.transactionMap.put(tid, minfo);
        return tid;
    }

    @Override
    FilenameFilter getFilenameFilter() {
        return vrfileFilter;
    }

    private void cacheMessageInfo(TransactionWorkInfo minfo) {
        this.transactionMap.put(minfo.getID(), minfo);
    }

    private Iterator getTransactionIterator() {
        return ((ConcurrentHashMap.KeySetView)this.transactionMap.keySet()).iterator();
    }

    private void setLoadedFlag(boolean flag) {
        this.loaded.set(flag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrTxnCount(int msgSize) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            ++this.txnCount;
            this.byteCount += (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrTxnCount(int msgSize) throws BrokerException {
        Object object = this.countLock;
        synchronized (object) {
            --this.txnCount;
            this.byteCount -= (long)msgSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCounts() {
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore:clearCounts for " + this.storeName);
        }
        Object object = this.countLock;
        synchronized (object) {
            this.txnCount = 0;
            this.byteCount = 0L;
        }
    }

    private void initCounts() throws BrokerException {
        if (this.vrfile != null) {
            Set msgs = this.vrfile.getRecords();
            for (VRecordRAF record : msgs) {
                short cookie = record.getCookie();
                if (cookie == -1 || cookie != 0) {
                    String warning = this.storeName + ": found a corrupted message at vrecord(" + record + "), a message might be lost";
                    this.logger.log(16, warning);
                    try {
                        this.vrfile.free(record);
                    }
                    catch (IOException e) {
                        this.logger.log(32, "Failed to free the corrupted vrecord: " + e);
                    }
                    continue;
                }
                try {
                    ++this.txnCount;
                    this.byteCount += (long)record.readInt();
                }
                catch (Throwable t) {
                    this.logger.log(32, "B4148", (Object)this.vrfile.getFile(), t);
                    throw new BrokerException(this.br.getString("B4148", this.vrfile.getFile()), t);
                }
            }
        }
        long[] cnts = this.initCountsFromIndividualFiles();
        this.txnCount += (int)cnts[0];
        this.byteCount += cnts[1];
        if (Store.getDEBUG()) {
            this.logger.log(4, "DstMsgStore: initialized msg count=" + this.txnCount + "; byte count = " + this.byteCount);
        }
    }

    Hashtable getDebugState() {
        int numInVrfile = 0;
        if (this.vrfile != null) {
            numInVrfile = this.vrfile.getNRecords();
        }
        int numInFiles = this.txnCount - numInVrfile;
        Hashtable<String, String> t = new Hashtable<String, String>();
        t.put(this.storeName + ":messages in vrfile", String.valueOf(numInVrfile));
        t.put(this.storeName + ":messages in its own file", String.valueOf(numInFiles));
        return t;
    }

    boolean containsTransaction(TransactionUID tid) {
        return this.transactionMap.containsKey(tid);
    }

    BaseTransaction getTransaction(TransactionUID mid) throws IOException, BrokerException {
        TransactionWorkInfo msginfo = this.transactionMap.get(mid);
        if (msginfo == null) {
            String emsg = this.br.getKString("B3016", mid) + ": " + this.storeName;
            this.logger.log(32, emsg);
            throw new BrokerException(emsg);
        }
        return msginfo.getMessage();
    }

    void sync() throws BrokerException {
        try {
            if (Store.getDEBUG_SYNC()) {
                String msg = "PreparedtxnStore sync() ";
                this.logger.log(4, msg);
            }
            if (this.vrfile != null) {
                this.vrfile.force();
            }
        }
        catch (IOException e) {
            throw new BrokerException("Failed to synchronize data to disk for file: " + this.vrfile, e);
        }
    }

    void updateTransactionState(TransactionUID tid, int state, boolean sync) throws IOException, BrokerException {
        this.getTransactionInfo(tid).updateState(state, sync);
    }

    void updateTransactionCompletion(TransactionUID tid, boolean complete, boolean sync) throws IOException, BrokerException {
        int completionVal = complete ? 1 : 0;
        this.getTransactionInfo(tid).updateCompletion(completionVal, sync);
    }

    String getPrefix() {
        return "PreparedTxStore: " + Thread.currentThread().getName();
    }

    private static class TxnEnumeration
    implements Enumeration {
        PreparedTxnStore parent = null;
        Iterator itr = null;
        Iterator recitr = null;
        Enumeration msgEnum = null;
        Logger logger = Globals.getLogger();
        BrokerResources br = Globals.getBrokerResources();
        Object objToReturn = null;

        TxnEnumeration(PreparedTxnStore p, Iterator i) {
            this.parent = p;
            this.itr = i;
        }

        TxnEnumeration(PreparedTxnStore p, Iterator i, Enumeration e) {
            this.parent = p;
            this.recitr = i;
            this.msgEnum = e;
        }

        @Override
        public boolean hasMoreElements() {
            Object msg = null;
            if (this.itr != null) {
                if (this.itr.hasNext()) {
                    this.objToReturn = this.itr.next();
                    return true;
                }
                return false;
            }
            if (this.recitr != null) {
                while (this.recitr.hasNext()) {
                    try {
                        TransactionWorkInfo minfo = new TransactionWorkInfo(this.parent, (VRecordRAF)this.recitr.next());
                        this.objToReturn = minfo.getMessage();
                        this.parent.cacheMessageInfo(minfo);
                        return true;
                    }
                    catch (IOException e) {
                        this.logger.log(32, "B4143", (Object)this.parent.storeName, (Throwable)e);
                    }
                }
            }
            if (this.msgEnum.hasMoreElements()) {
                this.objToReturn = this.msgEnum.nextElement();
                return true;
            }
            this.parent.setLoadedFlag(true);
            return false;
        }

        public Object nextElement() {
            if (this.objToReturn != null) {
                Object result = null;
                if (this.objToReturn instanceof TransactionUID) {
                    try {
                        result = this.parent.getTransaction((TransactionUID)this.objToReturn);
                    }
                    catch (IOException e) {
                        this.logger.log(32, "B4005", this.objToReturn, this.parent.storeName, e);
                        throw new NoSuchElementException();
                    }
                    catch (BrokerException e) {
                        this.logger.log(32, "B4005", this.objToReturn, this.parent.storeName, e);
                        throw new NoSuchElementException();
                    }
                } else {
                    result = this.objToReturn;
                }
                this.objToReturn = null;
                return result;
            }
            throw new NoSuchElementException();
        }
    }
}

